#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <pthread.h>

//vrednosti za smer
#define NIKO_NE_PRELAZI 0
#define SMER_SEVER 1
#define SMER_JUG 2

//tipovi vozila
#define AUTOMOBIL 0
#define AUTOBUS 1
#define KAMION 2

int S = 5; //broj vozila sa severa
int J = 5; //broj vozila sa juga

pthread_mutex_t mutex;
pthread_cond_t cond;

int vozilaNaMostu = 0;
int smer = NIKO_NE_PRELAZI;
int brojAutobusaNaMostu = 0;
int kamionNaMostu = 0; //flag da li neki kamion prelazi most trenutno

void *voznjaSever(void *arg)
{
    long id = (long)arg;

    sleep(rand() % 5); //prilazak vozila nadvoznjaku
    int tipVozila = rand() % 3; //random odredjivanje tipa vozila AUTOMOBIL=0, AUTOBUS=1, KAMION=2

    if(tipVozila == AUTOMOBIL)
    {
        printf("SEVER: Automobil %ld je stigao do nadvoznjaka\n",id);

        pthread_mutex_lock(&mutex);
        while(smer == SMER_JUG || kamionNaMostu) //cekamo da predjemo
            pthread_cond_wait(&cond, &mutex);

        if(smer != SMER_SEVER && vozilaNaMostu == 0)
        {
            smer = SMER_SEVER;
        }
        vozilaNaMostu++;

        pthread_mutex_unlock(&mutex);

        printf("SEVER: Automobil %ld prelazi nadvoznjak.\n",id);
        sleep(rand()%3);

        pthread_mutex_lock(&mutex);
        
        vozilaNaMostu--;
        if(vozilaNaMostu == 0 && smer == SMER_SEVER)
        {
            smer = NIKO_NE_PRELAZI;
            pthread_cond_broadcast(&cond);
        }

        pthread_mutex_unlock(&mutex);
        printf("SEVER: Automobil %ld presao nadvoznjak.\n",id);
    }
    else if(tipVozila == AUTOBUS)
    {
        printf("SEVER: Autobus %ld je stigao do nadvoznjaka\n",id);

        pthread_mutex_lock(&mutex);
        while(smer == SMER_JUG || kamionNaMostu || brojAutobusaNaMostu>0) //cekamo da predjemo
            pthread_cond_wait(&cond, &mutex);

        if(smer != SMER_SEVER && vozilaNaMostu == 0)
        {
            smer = SMER_SEVER;
        }
        vozilaNaMostu++;
        brojAutobusaNaMostu++;
        pthread_mutex_unlock(&mutex);

        printf("SEVER: Autobus %ld prelazi nadvoznjak.\n",id);
        sleep(rand()%3);

        pthread_mutex_lock(&mutex);
        vozilaNaMostu--;
        brojAutobusaNaMostu--;
        if(vozilaNaMostu == 0 && smer == SMER_SEVER)
        {
            smer = NIKO_NE_PRELAZI;
            pthread_cond_broadcast(&cond);
        }
        pthread_mutex_unlock(&mutex);
        printf("SEVER: Autobus %ld presao nadvoznjak.\n",id);
    }
    else // tipVozila == KAMION
    {
        printf("SEVER: Kamion %ld je stigao do nadvoznjaka\n",id);

        pthread_mutex_lock(&mutex);
        while(smer == SMER_JUG || kamionNaMostu || vozilaNaMostu != 0) //cekamo da predjemo
            pthread_cond_wait(&cond, &mutex);

        if(smer != SMER_SEVER && vozilaNaMostu == 0)
        {
            smer = SMER_SEVER;
        }
        vozilaNaMostu++;
        kamionNaMostu = 1;
        pthread_mutex_unlock(&mutex);

        printf("SEVER: Kamion %ld prelazi nadvoznjak.\n",id);
        sleep(rand()%3);

        pthread_mutex_lock(&mutex);
        vozilaNaMostu--;
        kamionNaMostu = 0;
        if(vozilaNaMostu == 0 && smer == SMER_SEVER)
        {
            smer = NIKO_NE_PRELAZI;
            pthread_cond_broadcast(&cond);
        }
        pthread_mutex_unlock(&mutex);
        printf("SEVER: Kamion %ld presao nadvoznjak.\n",id);
    }
}

void *voznjaJug(void *arg)
{
    long id = (long)arg;

    sleep(rand() % 5); //prilazak vozila nadvoznjaku
    int tipVozila = rand() % 3;

    if(tipVozila == AUTOMOBIL)
    {
        printf("JUG: Automobil %ld je stigao do nadvoznjaka\n",id);

        pthread_mutex_lock(&mutex);
        while(smer == SMER_SEVER || kamionNaMostu) //cekamo da predjemo
            pthread_cond_wait(&cond, &mutex);

        if(smer != SMER_JUG && vozilaNaMostu == 0)
        {
            smer = SMER_JUG;
        }
        vozilaNaMostu++;

        pthread_mutex_unlock(&mutex);

        printf("JUG: Automobil %ld prelazi nadvoznjak.\n",id);
        sleep(rand()%3);

        pthread_mutex_lock(&mutex);
        
        vozilaNaMostu--;
        if(vozilaNaMostu == 0 && smer == SMER_JUG)
        {
            smer = NIKO_NE_PRELAZI;
            pthread_cond_broadcast(&cond);
        }

        pthread_mutex_unlock(&mutex);
        printf("JUG: Automobil %ld presao nadvoznjak.\n",id);
    }
    else if(tipVozila == AUTOBUS)
    {
        printf("JUG: Autobus %ld je stigao do nadvoznjaka\n",id);

        pthread_mutex_lock(&mutex);
        while(smer == SMER_SEVER || kamionNaMostu || brojAutobusaNaMostu>0) //cekamo da predjemo
            pthread_cond_wait(&cond, &mutex);

        if(smer != SMER_JUG && vozilaNaMostu == 0)
        {
            smer = SMER_JUG;
        }
        vozilaNaMostu++;
        brojAutobusaNaMostu++;
        pthread_mutex_unlock(&mutex);

        printf("JUG: Autobus %ld prelazi nadvoznjak.\n",id);
        sleep(rand()%3);

        pthread_mutex_lock(&mutex);
        vozilaNaMostu--;
        brojAutobusaNaMostu--;
        if(vozilaNaMostu == 0 && smer == SMER_JUG)
        {
            smer = NIKO_NE_PRELAZI;
            pthread_cond_broadcast(&cond);
        }
        pthread_mutex_unlock(&mutex);
        printf("JUG: Autobus %ld presao nadvoznjak.\n",id);
    }
    else // tipVozila == KAMION
    {
        printf("JUG: Kamion %ld je stigao do nadvoznjaka\n",id);

        pthread_mutex_lock(&mutex);
        while(smer == SMER_SEVER || kamionNaMostu || vozilaNaMostu != 0) //cekamo da predjemo
            pthread_cond_wait(&cond, &mutex);

        if(smer != SMER_JUG && vozilaNaMostu == 0)
        {
            smer = SMER_JUG;
        }
        vozilaNaMostu++;
        kamionNaMostu = 1;
        pthread_mutex_unlock(&mutex);

        printf("JUG: Kamion %ld prelazi nadvoznjak.\n",id);
        sleep(rand()%3);

        pthread_mutex_lock(&mutex);
        vozilaNaMostu--;
        kamionNaMostu = 0;
        if(vozilaNaMostu == 0 && smer == SMER_JUG)
        {
            smer = NIKO_NE_PRELAZI;
            pthread_cond_broadcast(&cond);
        }
        pthread_mutex_unlock(&mutex);
        printf("JUG: Kamion %ld presao nadvoznjak.\n",id);
    }
}



int main()
{
    pthread_t niti[S+J];

    pthread_mutex_init(&mutex, NULL);
    pthread_cond_init(&cond, NULL);

    long i;
    for(i=0; i<S; i++)
        pthread_create(&niti[i], NULL, voznjaSever, (void*)i);
    
    long t;
    for(t=0; t<J; t++)
        pthread_create(&niti[S+t], NULL, voznjaJug, (void*)(S+t));

    pthread_exit(NULL);

    return 0;
}